/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_22;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_7924;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qouteall.dimlib.api.DimensionAPI;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IECamera;
import qouteall.imm_ptl.core.ducks.IEClientPlayNetworkHandler;
import qouteall.imm_ptl.core.ducks.IEClientWorld;
import qouteall.imm_ptl.core.ducks.IEMinecraftClient;
import qouteall.imm_ptl.core.ducks.IEParticleManager;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.core.ducks.IEWorldRenderer;
import qouteall.imm_ptl.core.mixin.client.accessor.IEClientLevelData;
import qouteall.imm_ptl.core.mixin.client.accessor.IEClientLevel_Accessor;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.render.context_management.DimensionRenderHelper;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.CountDownInt;

@Environment(value=EnvType.CLIENT)
public class ClientWorldLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientWorldLoader.class);
    private static final CountDownInt LOG_LIMIT = new CountDownInt(20);
    public static final Event<Consumer<class_5321<class_1937>>> CLIENT_DIMENSION_DYNAMIC_REMOVE_EVENT = Helper.createConsumerEvent();
    public static final Event<Consumer<class_638>> CLIENT_WORLD_LOAD_EVENT = Helper.createConsumerEvent();
    private static final Map<class_5321<class_1937>, class_638> CLIENT_WORLD_MAP = new Object2ObjectOpenHashMap();
    public static final Map<class_5321<class_1937>, class_761> WORLD_RENDERER_MAP = new Object2ObjectOpenHashMap();
    public static final Map<class_5321<class_1937>, DimensionRenderHelper> RENDER_HELPER_MAP = new Object2ObjectOpenHashMap();
    @Nullable
    public static Map<class_5321<class_1937>, class_5321<class_2874>> dimIdToDimTypeId;
    private static final class_310 CLIENT;
    private static boolean isInitialized;
    private static boolean isCreatingClientWorld;
    public static boolean isClientRemoteTicking;
    private static boolean isWorldSwitched;
    private static boolean isReloadingOtherWorldRenderers;

    public static void init() {
        DimensionAPI.CLIENT_DIMENSION_UPDATE_EVENT.register(serverDimensions -> {
            if (ClientWorldLoader.getIsInitialized()) {
                List<class_5321> dimensionsToRemove = CLIENT_WORLD_MAP.keySet().stream().filter(dim -> !serverDimensions.contains(dim)).toList();
                for (class_5321 dim2 : dimensionsToRemove) {
                    ClientWorldLoader.disposeDimensionDynamically((class_5321<class_1937>)dim2);
                }
            }
        });
        IPCGlobal.CLIENT_EXIT_EVENT.register(() -> {
            dimIdToDimTypeId = null;
        });
    }

    public static boolean getIsInitialized() {
        return isInitialized;
    }

    public static boolean getIsCreatingClientWorld() {
        return isCreatingClientWorld;
    }

    public static void tick() {
        if (IPCGlobal.isClientRemoteTickingEnabled) {
            isClientRemoteTicking = true;
            CLIENT_WORLD_MAP.values().forEach(world -> {
                if (ClientWorldLoader.CLIENT.field_1687 != world) {
                    ClientWorldLoader.tickRemoteWorld(world);
                }
            });
            WORLD_RENDERER_MAP.values().forEach(worldRenderer -> {
                if (worldRenderer != ClientWorldLoader.CLIENT.field_1769) {
                    worldRenderer.method_3252();
                }
            });
            isClientRemoteTicking = false;
        }
        boolean lightmapTextureConflict = false;
        for (DimensionRenderHelper helper : RENDER_HELPER_MAP.values()) {
            helper.tick();
            if (helper.world == ClientWorldLoader.CLIENT.field_1687 || helper.lightmapTexture != ClientWorldLoader.CLIENT.field_1773.method_22974()) continue;
            assert (ClientWorldLoader.CLIENT.field_1687 != null);
            LOGGER.info("Lightmap Texture Conflict {} {}", (Object)helper.world.method_27983().method_29177(), (Object)ClientWorldLoader.CLIENT.field_1687.method_27983().method_29177());
            lightmapTextureConflict = true;
        }
        if (lightmapTextureConflict) {
            ClientWorldLoader.disposeRenderHelpers();
            LOGGER.info("Refreshed Lightmaps");
        }
    }

    public static void disposeRenderHelpers() {
        RENDER_HELPER_MAP.values().forEach(DimensionRenderHelper::cleanUp);
        RENDER_HELPER_MAP.clear();
    }

    private static void tickRemoteWorld(class_638 newWorld) {
        List nearbyPortals = CHelper.getClientNearbyPortals(10.0).collect(Collectors.toList());
        ClientWorldLoader.withSwitchedWorld(newWorld, () -> {
            block3: {
                try {
                    newWorld.method_18116();
                    newWorld.method_8441(() -> true);
                    if (!CLIENT.method_1493()) {
                        ClientWorldLoader.tickRemoteWorldRandomTicksClient(newWorld, nearbyPortals);
                    }
                    newWorld.method_38534();
                }
                catch (Throwable e) {
                    if (!LOG_LIMIT.tryDecrement()) break block3;
                    LOGGER.error("", e);
                }
            }
        });
    }

    private static void tickRemoteWorldRandomTicksClient(class_638 newWorld, List<Portal> nearbyPortals) {
        nearbyPortals.stream().filter(portal -> portal.getDestDim() == newWorld.method_27983()).findFirst().ifPresent(portal -> {
            assert (ClientWorldLoader.CLIENT.field_1724 != null);
            class_243 playerPos = ClientWorldLoader.CLIENT.field_1724.method_19538();
            class_243 center = portal.transformPoint(playerPos);
            class_4184 camera = ClientWorldLoader.CLIENT.field_1773.method_19418();
            class_243 oldCameraPos = camera.method_19326();
            ((IECamera)camera).portal_setPos(center);
            if (newWorld.method_8510() % 2L == 0L) {
                newWorld.method_2941((int)center.field_1352, (int)center.field_1351, (int)center.field_1350);
            }
            ClientWorldLoader.CLIENT.field_1713.method_3057();
            ((IECamera)camera).portal_setPos(oldCameraPos);
        });
    }

    public static void cleanUp() {
        WORLD_RENDERER_MAP.values().forEach(ClientWorldLoader::disposeWorldRenderer);
        for (class_638 clientWorld : CLIENT_WORLD_MAP.values()) {
            ((IEClientWorld)clientWorld).ip_resetWorldRendererRef();
        }
        CLIENT_WORLD_MAP.clear();
        WORLD_RENDERER_MAP.clear();
        ClientWorldLoader.disposeRenderHelpers();
        isInitialized = false;
    }

    private static void disposeWorldRenderer(class_761 worldRenderer) {
        worldRenderer.method_3244(null);
        if (worldRenderer != ClientWorldLoader.CLIENT.field_1769) {
            worldRenderer.close();
            ((IEWorldRenderer)worldRenderer).portal_fullyDispose();
        }
    }

    private static void disposeDimensionDynamically(class_5321<class_1937> dimension) {
        Validate.notNull((Object)ClientWorldLoader.CLIENT.field_1724, (String)"player is null", (Object[])new Object[0]);
        Validate.notNull((Object)ClientWorldLoader.CLIENT.field_1687, (String)"level is null", (Object[])new Object[0]);
        Validate.isTrue((ClientWorldLoader.CLIENT.field_1687.method_27983() != dimension ? 1 : 0) != 0, (String)"Cannot dispose current dimension", (Object[])new Object[0]);
        Validate.isTrue((ClientWorldLoader.CLIENT.field_1724.method_37908().method_27983() != dimension ? 1 : 0) != 0, (String)"Cannot dispose current dimension", (Object[])new Object[0]);
        Validate.isTrue((boolean)CLIENT.method_18854(), (String)"not on client thread", (Object[])new Object[0]);
        class_761 worldRenderer = WORLD_RENDERER_MAP.get(dimension);
        ClientWorldLoader.disposeWorldRenderer(worldRenderer);
        WORLD_RENDERER_MAP.remove(dimension);
        Validate.isTrue((ClientWorldLoader.CLIENT.field_1769 != worldRenderer ? 1 : 0) != 0);
        class_638 clientWorld = CLIENT_WORLD_MAP.get(dimension);
        ((IEClientWorld)clientWorld).ip_resetWorldRendererRef();
        CLIENT_WORLD_MAP.remove(dimension);
        DimensionRenderHelper renderHelper = RENDER_HELPER_MAP.remove(dimension);
        if (renderHelper != null) {
            renderHelper.cleanUp();
        }
        LOGGER.info("Client Dynamically Removed Dimension {}", (Object)dimension.method_29177());
        if (clientWorld.method_2935().method_14151() > 0) {
            LOGGER.error("The chunks of that dimension was not cleared before removal");
        }
        if (clientWorld.method_18120() > 0) {
            LOGGER.error("The entities of that dimension was not cleared before removal");
        }
        ClientWorldLoader.CLIENT.field_1773.method_3203();
        ((Consumer)CLIENT_DIMENSION_DYNAMIC_REMOVE_EVENT.invoker()).accept(dimension);
    }

    @NotNull
    public static class_761 getWorldRenderer(class_5321<class_1937> dimension) {
        ClientWorldLoader.initializeIfNeeded();
        class_761 result = WORLD_RENDERER_MAP.get(dimension);
        if (result == null) {
            LOGGER.warn("Acquiring LevelRenderer before acquiring Level. Something is probably wrong. {}", (Object)dimension.method_29177(), (Object)new Throwable());
            ClientWorldLoader.getWorld(dimension);
            result = WORLD_RENDERER_MAP.get(dimension);
            if (result == null) {
                throw new RuntimeException("Unable to get LevelRenderer of " + String.valueOf(dimension.method_29177()));
            }
        }
        return result;
    }

    @NotNull
    public static class_638 getWorld(class_5321<class_1937> dimension) {
        Validate.notNull(dimension, (String)"dimension is null", (Object[])new Object[0]);
        Validate.isTrue((boolean)CLIENT.method_18854());
        ClientWorldLoader.initializeIfNeeded();
        if (!CLIENT_WORLD_MAP.containsKey(dimension)) {
            return ClientWorldLoader.createSecondaryClientWorld(dimension);
        }
        class_638 result = CLIENT_WORLD_MAP.get(dimension);
        Validate.notNull((Object)result, (String)"null value in world map", (Object[])new Object[0]);
        return result;
    }

    @Nullable
    public static class_638 getOptionalWorld(class_5321<class_1937> dimension) {
        Validate.notNull(dimension, (String)"dimension is null", (Object[])new Object[0]);
        Validate.isTrue((boolean)CLIENT.method_18854(), (String)"not on client thread", (Object[])new Object[0]);
        if (ClientWorldLoader.getServerDimensions().contains(dimension)) {
            return ClientWorldLoader.getWorld(dimension);
        }
        return null;
    }

    public static DimensionRenderHelper getDimensionRenderHelper(class_5321<class_1937> dimension) {
        ClientWorldLoader.initializeIfNeeded();
        DimensionRenderHelper result = RENDER_HELPER_MAP.computeIfAbsent(dimension, dimensionType -> new DimensionRenderHelper((class_1937)ClientWorldLoader.getWorld(dimension)));
        Validate.isTrue((result.world.method_27983() == dimension ? 1 : 0) != 0);
        return result;
    }

    public static void initializeIfNeeded() {
        if (!isInitialized) {
            Validate.isTrue((ClientWorldLoader.CLIENT.field_1687 != null ? 1 : 0) != 0, (String)"level is null", (Object[])new Object[0]);
            Validate.isTrue((ClientWorldLoader.CLIENT.field_1769 != null ? 1 : 0) != 0, (String)"levelRenderer is null", (Object[])new Object[0]);
            Validate.notNull((Object)ClientWorldLoader.CLIENT.field_1724, (String)"player is null. This may be caused by prior initialization failure. The log may provide useful information.", (Object[])new Object[0]);
            Validate.isTrue((ClientWorldLoader.CLIENT.field_1724.method_37908() == ClientWorldLoader.CLIENT.field_1687 ? 1 : 0) != 0, (String)"The player level is not the same as client level", (Object[])new Object[0]);
            class_5321 playerDimension = ClientWorldLoader.CLIENT.field_1687.method_27983();
            CLIENT_WORLD_MAP.put((class_5321<class_1937>)playerDimension, ClientWorldLoader.CLIENT.field_1687);
            WORLD_RENDERER_MAP.put((class_5321<class_1937>)playerDimension, ClientWorldLoader.CLIENT.field_1769);
            RENDER_HELPER_MAP.put((class_5321<class_1937>)ClientWorldLoader.CLIENT.field_1687.method_27983(), new DimensionRenderHelper((class_1937)ClientWorldLoader.CLIENT.field_1687));
            isInitialized = true;
        }
    }

    private static class_638 createSecondaryClientWorld(class_5321<class_1937> dimension) {
        class_638 newWorld;
        Validate.notNull((Object)ClientWorldLoader.CLIENT.field_1724, (String)"player is null", (Object[])new Object[0]);
        Validate.isTrue((boolean)CLIENT.method_18854(), (String)"not on client thread", (Object[])new Object[0]);
        Set<class_5321<class_1937>> dimIds = ClientWorldLoader.getServerDimensions();
        if (!dimIds.contains(dimension)) {
            throw new RuntimeException("Cannot create invalid client dimension " + String.valueOf(dimension.method_29177()));
        }
        isCreatingClientWorld = true;
        CLIENT.method_16011().method_15396("create_world");
        int chunkLoadDistance = 3;
        class_761 worldRenderer = new class_761(CLIENT, CLIENT.method_1561(), CLIENT.method_31975(), CLIENT.method_22940());
        try {
            class_634 mainNetHandler = ClientWorldLoader.CLIENT.field_1724.field_3944;
            assert (ClientWorldLoader.CLIENT.field_1687 != null);
            Map<String, class_22> mapData = ((IEClientLevel_Accessor)ClientWorldLoader.CLIENT.field_1687).ip_getMapData();
            Validate.notNull(dimIdToDimTypeId, (String)"dimension type mapping is missing", (Object[])new Object[0]);
            class_5321<class_2874> dimensionTypeKey = dimIdToDimTypeId.get(dimension);
            if (dimensionTypeKey == null) {
                throw new IllegalStateException("Cannot find dimension type for %s in %s".formatted(dimension.method_29177(), dimIdToDimTypeId));
            }
            class_638.class_5271 currentProperty = (class_638.class_5271)((IEWorld)ClientWorldLoader.CLIENT.field_1687).ip_getLevelData();
            class_5455.class_6890 registryManager = mainNetHandler.method_29091();
            int simulationDistance = ClientWorldLoader.CLIENT.field_1687.method_39024();
            class_6880.class_6883 dimensionType = registryManager.method_30530(class_7924.field_41241).method_40290(dimensionTypeKey);
            class_638.class_5271 properties = new class_638.class_5271(currentProperty.method_207(), currentProperty.method_152(), ((IEClientLevelData)currentProperty).ip_getIsFlat());
            newWorld = new class_638(mainNetHandler, properties, dimension, (class_6880)dimensionType, chunkLoadDistance, simulationDistance, () -> ((class_310)CLIENT).method_16011(), worldRenderer, ClientWorldLoader.CLIENT.field_1687.method_27982(), ClientWorldLoader.CLIENT.field_1687.method_22385().field_20641);
            ((IEClientLevel_Accessor)newWorld).ip_setMapData(mapData);
            ((IEClientWorld)newWorld).ip_setTickRateManager(ClientWorldLoader.CLIENT.field_1687.method_54719());
            worldRenderer.method_3244(newWorld);
            worldRenderer.method_14491(CLIENT.method_1478());
            CLIENT_WORLD_MAP.put(dimension, newWorld);
            WORLD_RENDERER_MAP.put(dimension, worldRenderer);
            LOGGER.info("Client World Created {}", (Object)dimension.method_29177());
        }
        catch (Exception e) {
            throw new IllegalStateException("Creating Client World " + String.valueOf(dimension.method_29177()) + " " + String.valueOf(CLIENT_WORLD_MAP.keySet()), e);
        }
        finally {
            isCreatingClientWorld = false;
            CLIENT.method_16011().method_15407();
        }
        ((Consumer)CLIENT_WORLD_LOAD_EVENT.invoker()).accept(newWorld);
        return newWorld;
    }

    public static Set<class_5321<class_1937>> getServerDimensions() {
        assert (ClientWorldLoader.CLIENT.field_1724 != null);
        return ClientWorldLoader.CLIENT.field_1724.field_3944.method_29356();
    }

    public static Collection<class_638> getClientWorlds() {
        Validate.isTrue((boolean)isInitialized);
        return CLIENT_WORLD_MAP.values();
    }

    public static void _onWorldRendererReloaded() {
        Validate.isTrue((boolean)CLIENT.method_18854());
        if (ClientWorldLoader.CLIENT.field_1687 != null) {
            LOGGER.info("WorldRenderer reloaded {}", (Object)ClientWorldLoader.CLIENT.field_1687.method_27983().method_29177());
        }
        if (isReloadingOtherWorldRenderers) {
            return;
        }
        if (PortalRendering.isRendering()) {
            return;
        }
        if (ClientWorldLoader.getIsCreatingClientWorld()) {
            return;
        }
        isReloadingOtherWorldRenderers = true;
        List<class_5321> toReload = WORLD_RENDERER_MAP.keySet().stream().filter(d -> d != ClientWorldLoader.CLIENT.field_1687.method_27983()).toList();
        for (class_5321 dim : toReload) {
            class_638 world = CLIENT_WORLD_MAP.get(dim);
            Validate.notNull((Object)world, (String)"missing client world %s", (Object[])new Object[]{dim.method_29177()});
            ClientWorldLoader.withSwitchedWorld(world, () -> ClientWorldLoader.CLIENT.field_1769.method_3279());
        }
        isReloadingOtherWorldRenderers = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withSwitchedWorld(class_638 newWorld, Supplier<T> supplier) {
        Validate.isTrue((boolean)CLIENT.method_18854(), (String)"not on client thread", (Object[])new Object[0]);
        Validate.isTrue((ClientWorldLoader.CLIENT.field_1724 != null ? 1 : 0) != 0, (String)"player is null", (Object[])new Object[0]);
        class_634 networkHandler = CLIENT.method_1562();
        assert (networkHandler != null);
        class_638 originalWorld = ClientWorldLoader.CLIENT.field_1687;
        class_761 originalWorldRenderer = ClientWorldLoader.CLIENT.field_1769;
        class_638 originalNetHandlerWorld = networkHandler.method_2890();
        boolean originalIsWorldSwitched = isWorldSwitched;
        class_761 newWorldRenderer = ClientWorldLoader.getWorldRenderer((class_5321<class_1937>)newWorld.method_27983());
        Validate.notNull((Object)newWorldRenderer, (String)"new world renderer is null", (Object[])new Object[0]);
        ClientWorldLoader.CLIENT.field_1687 = newWorld;
        ((IEParticleManager)ClientWorldLoader.CLIENT.field_1713).ip_setWorld(newWorld);
        ((IEMinecraftClient)CLIENT).ip_setWorldRenderer(newWorldRenderer);
        ((IEClientPlayNetworkHandler)networkHandler).ip_setWorld(newWorld);
        isWorldSwitched = true;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            if (ClientWorldLoader.CLIENT.field_1687 != newWorld) {
                LOGGER.error("Respawn packet should not be redirected");
                originalWorld = ClientWorldLoader.CLIENT.field_1687;
                originalWorldRenderer = ClientWorldLoader.CLIENT.field_1769;
            }
            ClientWorldLoader.CLIENT.field_1687 = originalWorld;
            ((IEMinecraftClient)CLIENT).ip_setWorldRenderer(originalWorldRenderer);
            ((IEParticleManager)ClientWorldLoader.CLIENT.field_1713).ip_setWorld(originalWorld);
            ((IEClientPlayNetworkHandler)networkHandler).ip_setWorld(originalNetHandlerWorld);
            isWorldSwitched = originalIsWorldSwitched;
        }
    }

    public static void withSwitchedWorld(class_638 newWorld, Runnable runnable) {
        ClientWorldLoader.withSwitchedWorld(newWorld, () -> {
            runnable.run();
            return null;
        });
    }

    public static void withSwitchedWorldFailSoft(class_5321<class_1937> dim, Runnable runnable) {
        class_638 world = ClientWorldLoader.getOptionalWorld(dim);
        if (world == null) {
            LOGGER.error("Ignoring redirected task of invalid dimension {}", (Object)dim.method_29177(), (Object)new Throwable());
            return;
        }
        ClientWorldLoader.withSwitchedWorld(world, runnable);
    }

    public static boolean getIsWorldSwitched() {
        return isWorldSwitched;
    }

    static {
        CLIENT = class_310.method_1551();
        isInitialized = false;
        isCreatingClientWorld = false;
        isClientRemoteTicking = false;
        isWorldSwitched = false;
        isReloadingOtherWorldRenderers = false;
    }

    public static class RemoteCallables {
        public static void checkBiomeRegistry(Map<String, Integer> idMap) {
            class_746 player = class_310.method_1551().field_1724;
            assert (player != null);
            class_5455.class_6890 registryAccess = player.field_3944.method_29091();
            class_2378 biomes = registryAccess.method_30530(class_7924.field_41236);
            for (Map.Entry<String, Integer> entry : idMap.entrySet()) {
                class_2960 id = McHelper.newResourceLocation(entry.getKey());
                int expectedId = entry.getValue();
                if (biomes.method_10206((Object)((class_1959)biomes.method_10223(id))) == expectedId) continue;
                LOGGER.error("Biome id mismatch: {} {}", (Object)id, (Object)expectedId);
            }
            if (idMap.size() != biomes.method_10235().size()) {
                LOGGER.error("Biome id mismatch: size not equal");
            }
            LOGGER.info("Biome id check finished");
        }
    }
}

